/*******************************************************
Filename		:  app_column_name.sql
Release 		:  C2.0, C2.0.1
SIR			:  1558,1561, 1562
Description		:  Table to maintain customization columns display name v/s column names in Warehouse tables.
Author			:  Joseph Wilson
Date			:  07-02-2003
			   07-07-2003 - added station column values -JW
			   07-21-2003 - updated column names, added new sample pres columns -JW
			   07-22-2003 - added Bio and Habitat fields -JW
			   07-29-2003 - added PDL line -JW
			   08-12-2003 - added Help Link element -WN
			   08-22-2003 - moved Portable Data Logger element -JW
			   11/03/2003 - manually added blob fields -wn
                     	   11/05/2003 - separated time zone from date/time columns (SIR 1561) -CT 
			   11/07/2003 - added help links to new group date data elements (SIR 1562) -WN 
			   05/20/2004 - added standard result value and unit -JW
			   06/16/2004 - added standard stn lat, long, and datum -JW
			   07/01/2004 - updated element names and added new std lat/long values -JW
			   07/14/2004 - updated reports to use datum code rather than full desc -JW
			   07/29/2004 - added Description Text to Station report -JW
			   08/02/2004 - added help links for conv lat/long groups -JW
			   08/16/2004 - updated names of converted act lat/long report elements -JW
Comments		:  
**********************************************************/

set echo off
spool app_column_name.log

DROP TABLE APP_COLUMN_NAME;

--CREATE TABLE APP_COLUMN_NAME2 (COL_NAME VARCHAR2(30), PRINT_NAME VARCHAR2(40));
CREATE TABLE APP_COLUMN_NAME (
	ELEMENT_NAME VARCHAR2(255),
	PRINT_NAME VARCHAR2(255), 
	COL_NAME VARCHAR2(255),
	REG_REPORT_NUMBER NUMBER,
	REG_COL_ORDER NUMBER,
	REG_ELEMENT_DEFAULT CHAR(1),
	STN_REPORT_NUMBER NUMBER,
	STN_COL_ORDER NUMBER,
	STN_ELEMENT_DEFAULT CHAR(1),
	BIO_REPORT_NUMBER NUMBER,
	BIO_COL_ORDER NUMBER,
	BIO_ELEMENT_DEFAULT CHAR(1),
	HAB_REPORT_NUMBER NUMBER,
	HAB_COL_ORDER NUMBER,
	HAB_ELEMENT_DEFAULT CHAR(1),
	HELP_LINK  NUMBER
);

alter table app_column_name
--add constraint pk_app_col primary key (col_name)
add constraint pk_app_col primary key (element_name,col_name)
using index;
--tablespace storetindx;

--Insert Report elements
INSERT INTO APP_COLUMN_NAME VALUES ('Org ID','Org ID','FA.ORGANIZATION_ID',1,1,NULL,1,1,'Y',1,1,NULL,1,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Org Name','Org Name','ORGANIZATION_NAME',2,1,'Y',4,1,NULL,2,1,'Y',2,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Station ID','Station ID','FA.STATION_ID',3,1,'Y',2,1,'Y',3,1,'Y',3,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Name','Station Name','FA.STATION_NAME',4,1,NULL,3,1,'Y',4,1,NULL,4,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Location Info','State','STATE_NAME',5,3,'Y',NULL,NULL,NULL,5,3,'Y',5,3,'Y',551);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Location Info','County','COUNTY_NAME',5,4,'Y',NULL,NULL,NULL,5,4,'Y',5,4,'Y',551);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Location Info','HUC','FA.HYDROLOGIC_UNIT_CODE',5,5,'Y',NULL,NULL,NULL,5,5,'Y',5,5,'Y',551);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Lat/Long','Station Latitude','FA.STN_LATITUDE',5.5,1,'Y',NULL,NULL,NULL,5.5,1,'Y',5.5,1,'Y',551.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Lat/Long','Station Longitude','FA.STN_LONGITUDE',5.5,2,'Y',NULL,NULL,NULL,5.5,2,'Y',5.5,2,'Y',551.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Lat/Long','Station Horizontal Datum','FA.STN_HDATUM',5.5,3,'Y',NULL,NULL,NULL,5.5,3,'Y',5.5,3,'Y',551.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Station Lat/Long','Converted Station Latitude','FA.STN_STD_LATITUDE',5.6,1,NULL,NULL,NULL,NULL,5.6,1,NULL,5.6,1,NULL,551.2);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Station Lat/Long','Converted Station Longitude','FA.STN_STD_LONGITUDE',5.6,2,NULL,NULL,NULL,NULL,5.6,2,NULL,5.6,2,NULL,551.2);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Station Lat/Long','Converted Station Horizontal Datum','FA.STN_STD_HDATUM',5.6,3,NULL,NULL,NULL,NULL,5.6,3,NULL,5.6,3,NULL,551.2);
INSERT INTO APP_COLUMN_NAME VALUES ('S/G/O Indicator','S/G/O Indicator','FA.SGO_INDICATOR',6,1,NULL,7,1,NULL,6,1,NULL,6,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Visit Num','Visit Num','FA.STATION_VISIT_ID',7,1,'Y',NULL,NULL,NULL,7,1,'Y',7,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Visit Start','Visit Start','FA.VISIT_START_DATE_TIME',8,1,NULL,NULL,NULL,NULL,8,1,NULL,8,1,NULL,552);
INSERT INTO APP_COLUMN_NAME VALUES ('Visit Start','Zone','FA.VISIT_START_TIME_ZONE',8,2,NULL,NULL,NULL,NULL,8,2,NULL,8,2,NULL,552);
INSERT INTO APP_COLUMN_NAME VALUES ('Visit Stop','Visit Stop','FA.VISIT_STOP_DATE_TIME',9,1,NULL,NULL,NULL,NULL,9,1,NULL,9,1,NULL,553);
INSERT INTO APP_COLUMN_NAME VALUES ('Visit Stop','Zone','FA.VISIT_STOP_TIME_ZONE',9,2,NULL,NULL,NULL,NULL,9,2,NULL,9,2,NULL,553);
INSERT INTO APP_COLUMN_NAME VALUES ('Trip ID','Trip ID','FA.TRIP_ID',10,1,NULL,NULL,NULL,NULL,10,1,NULL,10,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Trip Name','Trip Name','FA.TRIP_NAME',11,1,NULL,NULL,NULL,NULL,11,1,NULL,11,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity ID','Activity ID','FA.ACTIVITY_ID',12,1,'Y',NULL,NULL,NULL,12,1,'Y',12,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Start','Activity Start','FA.ACTIVITY_START_DATE_TIME',13,1,'Y',NULL,NULL,NULL,13,1,'Y',13,1,'Y',554);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Start','Zone','FA.ACT_START_TIME_ZONE',13,2,'Y',NULL,NULL,NULL,13,2,'Y',13,2,'Y',554);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Stop','Activity Stop','FA.ACTIVITY_STOP_DATE_TIME',14,1,NULL,NULL,NULL,NULL,14,1,NULL,14,1,NULL,555);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Stop','Zone','FA.ACT_STOP_TIME_ZONE',14,2,NULL,NULL,NULL,NULL,14,2,NULL,14,2,NULL,555);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Medium','Activity Medium','FA.ACTIVITY_MEDIUM',15,1,'Y',NULL,NULL,NULL,15,1,'Y',NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Matrix','Activity Matrix','FA.ACTIVITY_MATRIX',16,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Type','Activity Type','FA.ACTIVITY_TYPE',17,1,'Y',NULL,NULL,NULL,16,1,'Y',15,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Category-Rep Num','Activity Category-Rep Num','FA.ACTIVITY_CATEGORY',18,1,NULL,NULL,NULL,NULL,17,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Intent','Activity Intent','FA.ACTIVITY_INTENT',19,1,NULL,NULL,NULL,NULL,18,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Community Sampled','Community Sampled','FA.ACTIVITY_COMMUNITY',NULL,NULL,NULL,NULL,NULL,NULL,19,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Subject Taxon','Subject Taxon','FA.ACTIVITY_SUBJECT_TAXON',NULL,NULL,NULL,NULL,NULL,NULL,20,1,'Y',NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Biopart','Biopart','FA.BIOPART_NAME',NULL,NULL,NULL,NULL,NULL,NULL,21,1,'Y',NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Field Set','Field Set','FA.FIELD_SET',20,1,NULL,NULL,NULL,NULL,22,1,NULL,16,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Actual Point Type','Actual Location Point Type','FA.LOCATION_POINT_TYPE',21,1,NULL,NULL,NULL,NULL,23,1,NULL,17,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Actual Point Sequence','Actual Point Sequence Num','FA.POINT_SEQUENCE_NUMBER',22,1,NULL,NULL,NULL,NULL,24,1,NULL,18,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Actual Point Name','Actual Point Name','FA.POINT_NAME',23,1,NULL,NULL,NULL,NULL,25,1,NULL,19,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Actual Activity Lat/Long','Actual Activity Latitude','FA.ACTIVITY_LATITUDE',24,1,NULL,NULL,NULL,NULL,26,1,NULL,20,1,NULL,555.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Actual Activity Lat/Long','Actual Activity Longitude','FA.ACTIVITY_LONGITUDE',24,2,NULL,NULL,NULL,NULL,26,2,NULL,20,2,NULL,555.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Actual Activity Lat/Long','Actual Activity Horizontal Datum','HD.ID_CODE',24,3,NULL,NULL,NULL,NULL,26,3,NULL,20,3,NULL,555.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Actual Activity Lat/Long','Converted Actual Activity Latitude','FA.ACT_STD_LATITUDE',25,1,NULL,NULL,NULL,NULL,27,1,NULL,21,1,NULL,555.2);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Actual Activity Lat/Long','Converted Actual Activity Longitude','FA.ACT_STD_LONGITUDE',25,2,NULL,NULL,NULL,NULL,27,2,NULL,21,2,NULL,555.2);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Actual Activity Lat/Long','Converted Actual Activity Horizontal Datum','ACT_STD_HDATUM',25,3,NULL,NULL,NULL,NULL,27,3,NULL,21,3,NULL,555.2);
INSERT INTO APP_COLUMN_NAME VALUES ('Well Number','Well Number','FA.WELL_NUMBER',27,1,NULL,8,1,NULL,28,1,NULL,22,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Pipe Number','Pipe Number','FA.PIPE_NUMBER',28,1,NULL,10,1,NULL,29,1,NULL,23,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Act Location Info','Geopositioning Method','GEOPOSITIONING_METHOD',29,1,NULL,NULL,NULL,NULL,30,1,NULL,24,1,NULL,556);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Act Location Info','Map Scale','FA.MAP_SCALE',29,3,NULL,NULL,NULL,NULL,30,3,NULL,24,3,NULL,556);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Depth','Activity Depth','FA.ACTIVITY_DEPTH',30,1,'Y',NULL,NULL,NULL,31,1,'Y',NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Depth Unit','Activity Depth Unit','FA.ACTIVITY_DEPTH_UNIT',31,1,'Y',NULL,NULL,NULL,32,1,'Y',NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Upper Depth','Activity Upper Depth','FA.ACTIVITY_UPPER_DEPTH',32,1,NULL,NULL,NULL,NULL,33,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Rel Depth','Activity Rel Depth','FA.ACTIVITY_REL_DEPTH',33,1,NULL,NULL,NULL,NULL,34,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Lower Depth','Activity Lower Depth','FA.ACTIVITY_LOWER_DEPTH',34,1,NULL,NULL,NULL,NULL,35,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Upr Lwr Depth Unit','Upr Lwr Depth Unit','FA.UPR_LWR_DEPTH_UNIT',35,1,NULL,NULL,NULL,NULL,36,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Sample Collection ID','Sample Collection ID','FA.FIELD_PROCEDURE_ID',36,1,NULL,NULL,NULL,NULL,37,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Field Gear ID','Field Gear ID','FA.FIELD_GEAR_ID',37,1,NULL,NULL,NULL,NULL,38,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Field Gear Config ID','Field Gear Config ID','FA.GEAR_CONFIG_ID',38,1,NULL,NULL,NULL,NULL,39,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Sample Preservation','Container Desc','FA.CONTAINER_DESC',39,1,NULL,NULL,NULL,NULL,40,1,NULL,NULL,NULL,NULL,557);
INSERT INTO APP_COLUMN_NAME VALUES ('Sample Preservation','Temp Pres Type','FA.TEMP_PRESERVN_TYPE',39,2,NULL,NULL,NULL,NULL,40,2,NULL,NULL,NULL,NULL,557);
INSERT INTO APP_COLUMN_NAME VALUES ('Sample Preservation','Pres Storage Proc','FA.PRESRV_STRGE_PRCDR',39,3,NULL,NULL,NULL,NULL,40,3,NULL,NULL,NULL,NULL,557);
INSERT INTO APP_COLUMN_NAME VALUES ('Characteristic Name','Characteristic Name','FA.CHARACTERISTIC_NAME',40,1,'Y',NULL,NULL,NULL,41,1,'Y',25,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('CAS Num','CAS Num','FA.CAS_NUMBER',41,1,NULL,NULL,NULL,NULL,41.5,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('EPA Registry Num','EPA Registry Num','FA.EPA_REG_NUMBER',42,1,NULL,NULL,NULL,NULL,42,1,NULL,27,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('ITIS Num','ITIS Num','FA.ITIS_NUMBER',43,1,NULL,NULL,NULL,NULL,43,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Sample Fraction','Sample Fraction','FA.SAMPLE_FRACTION_TYPE',44,1,'Y',NULL,NULL,NULL,44,1,'Y',29,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Value Type','Value Type','FA.RESULT_VALUE_TYPE',45,1,'Y',NULL,NULL,NULL,45,1,'Y',30,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Statistic Type','Statistic Type','FA.STATISTIC_TYPE',46,1,'Y',NULL,NULL,NULL,46,1,'Y',31,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Result Value as Text','Result Value as Text','FA.RESULT_VALUE_TEXT',47,1,'Y',NULL,NULL,NULL,47,1,'Y',32,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Result Value as Number','Result Value as Number','FA.RESULT_VALUE',48,1,NULL,NULL,NULL,NULL,48,1,NULL,33,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Units','Units','FA.RESULT_UNIT',49,1,'Y',NULL,NULL,NULL,49,1,'Y',34,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Converted Result Value','Converted Result Value','FA.STD_VALUE',49.5,1,NULL,NULL,NULL,NULL,49.5,1,NULL,34.5,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Converted Result Unit','Converted Result Unit','FA.STD_UNIT',49.6,1,NULL,NULL,NULL,NULL,49.6,1,NULL,34.6,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Result Comment','Result Comment','FA.RESULT_COMMENT',50,1,NULL,NULL,NULL,NULL,50,1,NULL,35,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Result Free Text','Result Free Text','FA.TEXT_RESULT',51,1,NULL,NULL,NULL,NULL,51,1,NULL,36,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Weight Basis','Weight Basis','FA.WEIGHT_BASIS_TYPE',52,1,NULL,NULL,NULL,NULL,52,1,NULL,37,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Temperature Basis','Temperature Basis','FA.TEMPERATURE_BASIS_LEVEL',53,1,NULL,NULL,NULL,NULL,53,1,NULL,38,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Duration Basis','Duration Basis','FA.DURATION_BASIS',54,1,NULL,NULL,NULL,NULL,54,1,NULL,39,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Particle Size Basis','Particle Size Basis','FA.PARTICLE_SIZE',55,1,NULL,NULL,NULL,NULL,55,1,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Distance Measured From','Distance Measured From','FA.DISTANCE_MEASURE_FROM',56,1,NULL,NULL,NULL,NULL,56,1,NULL,40,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Distance Measured To','Distance Measured To','FA.DISTANCE_MEASURE_TO',57,1,NULL,NULL,NULL,NULL,57,1,NULL,41,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Analytical Proc ID','Analytical Proc ID','FA.ANALYTICAL_PROCEDURE_SOURCE',58,1,'Y',NULL,NULL,NULL,58,1,'Y',42,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Anal Proc Info','Detection Limit','FA.DETECTION_LIMIT',59,2,NULL,NULL,NULL,NULL,59,1,NULL,43,1,NULL,558);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Anal Proc Info','Detection Limit Descript','FA.DETECTION_LIMIT_DESCRIPTION',59,3,NULL,NULL,NULL,NULL,59,2,NULL,43,2,NULL,558);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Anal Proc Info','Lower Quantification Limit','FA.LOWER_QUANTITATION_LIMIT',59,4,NULL,NULL,NULL,NULL,59,3,NULL,43,3,NULL,558);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Anal Proc Info','Upper Quantification Limit','FA.UPPER_QUANTITATION_LIMIT',59,5,NULL,NULL,NULL,NULL,59,4,NULL,43,4,NULL,558);
INSERT INTO APP_COLUMN_NAME VALUES ('Lab Remark','Lab Remark','FA.LAB_REMARK',60,1,NULL,NULL,NULL,NULL,60,1,NULL,44,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Dilution Ind','Dilution Ind','FA.DILUTION_INDICATOR',61,1,NULL,NULL,NULL,NULL,61,1,NULL,45,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Recovery Ind','Recovery Ind','FA.RECOVERY_INDICATOR',62,1,NULL,NULL,NULL,NULL,62,1,NULL,46,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Correction Ind','Correction Ind','FA.CORRECTION_INDICATOR',63,1,NULL,NULL,NULL,NULL,63,1,NULL,47,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Other Lab Info','Lab ID','FA.LAB_ID',64,1,NULL,NULL,NULL,NULL,64,1,NULL,48,1,NULL,559);
INSERT INTO APP_COLUMN_NAME VALUES ('Other Lab Info','Lab Name','FA.LAB_NAME',64,2,NULL,NULL,NULL,NULL,64,2,NULL,48,2,NULL,559);
INSERT INTO APP_COLUMN_NAME VALUES ('Other Lab Info','Lab Cert','FA.LAB_CERTIFIED',64,3,NULL,NULL,NULL,NULL,64,3,NULL,48,3,NULL,559);
INSERT INTO APP_COLUMN_NAME VALUES ('Other Lab Info','Lab Batch ID','FA.LAB_BATCH_ID',64,4,NULL,NULL,NULL,NULL,64,4,NULL,48,4,NULL,559);
INSERT INTO APP_COLUMN_NAME VALUES ('Other Lab Info','Analysis Date','FA.ANALYSIS_DATE_TIME',64,5,NULL,NULL,NULL,NULL,64,5,NULL,48,5,NULL,559);
INSERT INTO APP_COLUMN_NAME VALUES ('Other Lab Info','Zone','FA.ANALYSIS_TIME_ZONE',64,6,NULL,NULL,NULL,NULL,64,6,NULL,48,6,NULL,559);
INSERT INTO APP_COLUMN_NAME VALUES ('Num of Reps','Num of Reps','FA.REPLICATE_ANALYSIS_COUNT',65,1,NULL,NULL,NULL,NULL,65,1,NULL,49,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Precision','Precision','FA.PRECISION',66,1,NULL,NULL,NULL,NULL,66,1,NULL,50,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Bias','Bias','FA.BIAS',67,1,NULL,NULL,NULL,NULL,67,1,NULL,51,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Conf Level','Conf Level','FA.CONFIDENCE_LEVEL',68,1,NULL,NULL,NULL,NULL,68,1,NULL,52,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Correction for Bias Ind','Correction for Bias Ind','FA.CONF_LVL_CORR_BIAS',69,1,NULL,NULL,NULL,NULL,69,1,NULL,53,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Result Document/Graphic Name','Result Document/Graphic Name ','FA.BLOB_TITLE',70,1,NULL,NULL,NULL,NULL,78,1,NULL,54,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Result Document/Graphic URL','Result Document/Graphic URL','FA.BLOB_ID',71,1,NULL,NULL,NULL,NULL,79,1,NULL,55,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Document/Graphic Name','Activity Document/Graphic Name','FA.ACT_BLOB_TITLE',72,1,NULL,NULL,NULL,NULL,80,1,NULL,56,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Activity Document/Graphic URL','Activity Document/Graphic URL','FA.ACT_BLOB_ID',73,1,NULL,NULL,NULL,NULL,81,1,NULL,57,1,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Portable Data Logger','Portable Data Logger','FA.PORTABLE_DATA_LOGGER',39.5,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Start Point Name','FA.TR_START_POINT_NAME',NULL,NULL,NULL,NULL,NULL,NULL,70,1,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Start Latitude','FA.TR_START_LATITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,2,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Start Longitude','FA.TR_START_LONGITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,3,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Start Datum','FA.TR_START_HDATUM',NULL,NULL,NULL,NULL,NULL,NULL,70,3.1,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Conv Trawl Start Latitude','FA.TR_START_STD_LATITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,3.2,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Conv Trawl Start Longitude','FA.TR_START_STD_LONGITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,3.3,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Conv Trawl Start Datum','FA.TR_START_STD_HDATUM',NULL,NULL,NULL,NULL,NULL,NULL,70,3.4,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Start Depth','FA.TR_START_DEPTH',NULL,NULL,NULL,NULL,NULL,NULL,70,4,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Stop Point Name','FA.TR_STOP_POINT_NAME',NULL,NULL,NULL,NULL,NULL,NULL,70,5,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Stop Latitude','FA.TR_STOP_LATITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,6,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Stop Longitude','FA.TR_STOP_LONGITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,7,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Stop Datum','FA.TR_STOP_HDATUM',NULL,NULL,NULL,NULL,NULL,NULL,70,7.1,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Conv Trawl Stop Latitude','FA.TR_STOP_STD_LATITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,7.2,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Conv Trawl Stop Longitude','FA.TR_STOP_STD_LONGITUDE',NULL,NULL,NULL,NULL,NULL,NULL,70,7.3,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Conv Trawl Stop Datum','FA.TR_STOP_STD_HDATUM',NULL,NULL,NULL,NULL,NULL,NULL,70,7.4,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Stop Depth','FA.TR_STOP_DEPTH',NULL,NULL,NULL,NULL,NULL,NULL,70,8,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Fished Duration Measure','FA.FISHED_DURATION',NULL,NULL,NULL,NULL,NULL,NULL,70,9,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Boat Speed','FA.BOAT_SPEED',NULL,NULL,NULL,NULL,NULL,NULL,70,10,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Fished Distance','FA.FISHED_DISTANCE',NULL,NULL,NULL,NULL,NULL,NULL,70,11,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Rel Current Dir','FA.REL_CURRENT_DIR',NULL,NULL,NULL,NULL,NULL,NULL,70,12,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Rel Wind Dir','FA.REL_WIND_DIR',NULL,NULL,NULL,NULL,NULL,NULL,70,13,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Tow Info','Trawl Comment','FA.TRAWL_COMMENT',NULL,NULL,NULL,NULL,NULL,NULL,70,14,NULL,NULL,NULL,NULL,5510);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Voltage Measure','FA.VOLTAGE_MEASURE',NULL,NULL,NULL,NULL,NULL,NULL,71,1,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Current Type Code','FA.CURRENT_TYPE_CODE',NULL,NULL,NULL,NULL,NULL,NULL,71,2,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Amperage Measure','FA.AMPERAGE_MEASURE',NULL,NULL,NULL,NULL,NULL,NULL,71,3,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Pass Count','FA.PASS_COUNT',NULL,NULL,NULL,NULL,NULL,NULL,71,4,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Pass Length Measure','FA.PASS_LENGTH',NULL,NULL,NULL,NULL,NULL,NULL,71,5,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Pulse Rate Measure','FA.PULSE_RATE',NULL,NULL,NULL,NULL,NULL,NULL,71,6,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Electroshock Comment','FA.ELECTROSHOCK_COMMENT',NULL,NULL,NULL,NULL,NULL,NULL,71,7,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Electroshock Info','Total Energzd Time','FA.TOTAL_ENERGZD_TIME',NULL,NULL,NULL,NULL,NULL,NULL,71,8,NULL,NULL,NULL,NULL,5511);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Non-Tow Info','Sampling Duration','FA.SAMPLING_DURATION',NULL,NULL,NULL,NULL,NULL,NULL,72,1,NULL,NULL,NULL,NULL,5512);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Non-Tow Info','Orientation to Current','FA.ORIENTATION_TO_CURRENT',NULL,NULL,NULL,NULL,NULL,NULL,72,2,NULL,NULL,NULL,NULL,5512);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Non-Tow Info','Rel Current Dir','FA.REL_CURRENT_DIR',NULL,NULL,NULL,NULL,NULL,NULL,72,3,NULL,NULL,NULL,NULL,5512);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Non-Tow Info','Rel Wind Dir','FA.REL_WIND_DIR',NULL,NULL,NULL,NULL,NULL,NULL,72,4,NULL,NULL,NULL,NULL,5512);
INSERT INTO APP_COLUMN_NAME VALUES ('Net Non-Tow Info','Trap Net Comment','FA.TRAP_NET_COMMENT',NULL,NULL,NULL,NULL,NULL,NULL,72,5,NULL,NULL,NULL,NULL,5512);
INSERT INTO APP_COLUMN_NAME VALUES ('General Group Info','Bio Result Group ID','FA.BIO_GROUP_ID',NULL,NULL,NULL,NULL,NULL,NULL,73,1,NULL,NULL,NULL,NULL,5513);
INSERT INTO APP_COLUMN_NAME VALUES ('General Group Info','Bio Result Group Type','FA.BIO_GROUP_TYPE',NULL,NULL,NULL,NULL,NULL,NULL,73,2,NULL,NULL,NULL,NULL,5513);
INSERT INTO APP_COLUMN_NAME VALUES ('General Group Info','Bio Result Group Subj Txn','FA.BIO_GROUP_SUBJECT_TXN',NULL,NULL,NULL,NULL,NULL,NULL,73,3,NULL,NULL,NULL,NULL,5513);
INSERT INTO APP_COLUMN_NAME VALUES ('General Group Info','Bio Result Group Desc','FA.BIO_GROUP_DESCRIPTION',NULL,NULL,NULL,NULL,NULL,NULL,73,4,NULL,NULL,NULL,NULL,5513);
INSERT INTO APP_COLUMN_NAME VALUES ('Multi-Taxon Pop Census Info','Feeding Group','FA.FEEDING_GROUP',NULL,NULL,NULL,NULL,NULL,NULL,74,1,NULL,NULL,NULL,NULL,5514);
INSERT INTO APP_COLUMN_NAME VALUES ('Multi-Taxon Pop Census Info','Pollution Tolerance','FA.POLLUTION_TOLERANCE',NULL,NULL,NULL,NULL,NULL,NULL,74,2,NULL,NULL,NULL,NULL,5514);
INSERT INTO APP_COLUMN_NAME VALUES ('Multi-Taxon Pop Census Info','Trophic Level','FA.TROPHIC_LEVEL',NULL,NULL,NULL,NULL,NULL,NULL,74,3,NULL,NULL,NULL,NULL,5514);
INSERT INTO APP_COLUMN_NAME VALUES ('Multi-Taxon Pop Census Info','Habit','FA.HABIT',NULL,NULL,NULL,NULL,NULL,NULL,74,4,NULL,NULL,NULL,NULL,5514);
INSERT INTO APP_COLUMN_NAME VALUES ('Multi-Taxon Pop Census Info','Voltinism','FA.VOLTINISM',NULL,NULL,NULL,NULL,NULL,NULL,74,5,NULL,NULL,NULL,NULL,5514);
INSERT INTO APP_COLUMN_NAME VALUES ('Multi-Taxon Pop Census Info','Cell Shape','FA.CELL_SHAPE',NULL,NULL,NULL,NULL,NULL,NULL,74,6,NULL,NULL,NULL,NULL,5514);
INSERT INTO APP_COLUMN_NAME VALUES ('Multi-Taxon Pop Census Info','Cell Form','FA.CELL_FORM',NULL,NULL,NULL,NULL,NULL,NULL,74,7,NULL,NULL,NULL,NULL,5514);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Group Summary Info','Number in Group','FA.NUMBER_IN_GROUP',NULL,NULL,NULL,NULL,NULL,NULL,75,1,NULL,NULL,NULL,NULL,5515);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Group Summary Info','Group Count Type','FA.BIO_GROUP_COUNT_TYPE',NULL,NULL,NULL,NULL,NULL,NULL,75,2,NULL,NULL,NULL,NULL,5515);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Phys/Bio Ind','FA.PHYS_BIO_INDICATOR',NULL,NULL,NULL,NULL,NULL,NULL,76,1,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Bio Result Group ID (sex)','FA.GROUP_DESC_SEX',NULL,NULL,NULL,NULL,NULL,NULL,76,2,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Bio Result Group ID (lifestage)','FA.GROUP_DESC_LIFESTAGE',NULL,NULL,NULL,NULL,NULL,NULL,76,3,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Bio Result Group Class Var','FA.COMMON_CLASS_DESC',NULL,NULL,NULL,NULL,NULL,NULL,76,4,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Class Prim Desc','FA.PRIMARY_CLASS_DESC',NULL,NULL,NULL,NULL,NULL,NULL,76,5,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Class Sec Desc','FA.SECONDARY_CLASS_DESC',NULL,NULL,NULL,NULL,NULL,NULL,76,6,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Class Upper Bound','FA.LOWER_BOUND_AMOUNT',NULL,NULL,NULL,NULL,NULL,NULL,76,8,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Class Lower Bound','FA.UPPER_BOUND_AMOUNT',NULL,NULL,NULL,NULL,NULL,NULL,76,7,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Frequency Class Info','Units','FA.BIO_RCI_UNITS',NULL,NULL,NULL,NULL,NULL,NULL,76,9,NULL,NULL,NULL,NULL,5516);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Individual Info','Number in Group','FA.NUMBER_IN_GROUP',NULL,NULL,NULL,NULL,NULL,NULL,77,1,NULL,NULL,NULL,NULL,5517);
INSERT INTO APP_COLUMN_NAME VALUES ('Single Taxon Individual Info','Bio Individual Number','FA.INDIVIDUAL_NUMBER',NULL,NULL,NULL,NULL,NULL,NULL,77,2,NULL,NULL,NULL,NULL,5517);
INSERT INTO APP_COLUMN_NAME VALUES ('Habitat Class Name','Habitat Class Name','FA.HABITAT_CLASS_NAME',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,26,1,'Y',0);
INSERT INTO APP_COLUMN_NAME VALUES ('Primary Type','Primary Type','PRIMARY_TYPE',NULL,NULL,NULL,5,1,'Y',NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Secondary Type','Secondary Type','SECONDARY_TYPE',NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Well Name','Well Name','FA.WELL_NAME',NULL,NULL,NULL,9,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('NAICS Code','NAICS Code','FA.NAICS_CODE',NULL,NULL,NULL,11,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Spring Info','Spring Type Improvement','FA.SPRING_TYPE_IMPROVEMENT',NULL,NULL,NULL,12,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,651);
INSERT INTO APP_COLUMN_NAME VALUES ('Spring Info','Permanence','FA.SPRING_PERMANENCE',NULL,NULL,NULL,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,651);
INSERT INTO APP_COLUMN_NAME VALUES ('Spring Info','USGS Geologic Unit Code-Name','FA.SPRING_USGS_GEOLOGIC_UNIT',NULL,NULL,NULL,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,651);
INSERT INTO APP_COLUMN_NAME VALUES ('Spring Info','Spring Other Name','FA.SPRING_OTHER_NAME',NULL,NULL,NULL,12,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,651);
INSERT INTO APP_COLUMN_NAME VALUES ('Spring Info','USGS Lithologic Unit Code-Name','FA.SPRING_USGS_LITHOLOGIC_UNIT',NULL,NULL,NULL,12,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,651);
INSERT INTO APP_COLUMN_NAME VALUES ('Location Point Type','Location Point Type','FA.LOCATION_POINT_TYPE',NULL,NULL,NULL,13,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Point Sequence Number','Point Sequence Number','FA.POINT_SEQUENCE_NUMBER',NULL,NULL,NULL,14,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Point Name','Point Name','FA.POINT_NAME',NULL,NULL,NULL,15,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Latitude/Longitude','Latitude','FA.LATITUDE',NULL,NULL,NULL,16,1,'Y',NULL,NULL,NULL,NULL,NULL,NULL,652);
INSERT INTO APP_COLUMN_NAME VALUES ('Latitude/Longitude','Longitude','FA.LONGITUDE',NULL,NULL,NULL,16,2,'Y',NULL,NULL,NULL,NULL,NULL,NULL,652);
INSERT INTO APP_COLUMN_NAME VALUES ('Latitude/Longitude','Horizontal Datum','HD.ID_CODE',NULL,NULL,NULL,16,3,'Y',NULL,NULL,NULL,NULL,NULL,NULL,652);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Latitude/Longitude','Converted Latitude','FA.STD_LATITUDE',NULL,NULL,NULL,16.5,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Latitude/Longitude','Converted Longitude','FA.STD_LONGITUDE',NULL,NULL,NULL,16.5,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Conv Latitude/Longitude','Converted Horizontal Datum','SHD.ID_CODE',NULL,NULL,NULL,16.5,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652.1);
INSERT INTO APP_COLUMN_NAME VALUES ('Lat/Long Info','Geopositioning Method','GEOPOSITIONING_METHOD',NULL,NULL,NULL,17,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,653);
INSERT INTO APP_COLUMN_NAME VALUES ('Lat/Long Info','Map Scale','FA.MAP_SCALE',NULL,NULL,NULL,17,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,653);
INSERT INTO APP_COLUMN_NAME VALUES ('Elevation (w/ Units)','Elevation','FA.ELEVATION',NULL,NULL,NULL,18,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Elevation Info','Elevation Datum','ELEVATION_DATUM',NULL,NULL,NULL,19,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,654);
INSERT INTO APP_COLUMN_NAME VALUES ('Additional Elevation Info','Elevation Method','ELEVATION_METHOD',NULL,NULL,NULL,19,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,654);
INSERT INTO APP_COLUMN_NAME VALUES ('Country Name','Country Name','COUNTRY_NAME',NULL,NULL,NULL,20,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('State','State','STATE_NAME',NULL,NULL,NULL,21,1,'Y',NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('County','County','COUNTY_NAME',NULL,NULL,NULL,22,1,'Y',NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Hydrologic Unit Code','Hydrologic Unit Code','FA.HYDROLOGIC_UNIT_CODE',NULL,NULL,NULL,23,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Hydrologic Unit Name','Hydrologic Unit Name','HYDROLOGIC_UNIT_NAME',NULL,NULL,NULL,24,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('RF1 Info','RF1 Segment Code','FA.RF1_SEGMENT_CODE',NULL,NULL,NULL,25,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,655);
INSERT INTO APP_COLUMN_NAME VALUES ('RF1 Info','RF1 Segment Name','FA.RF1_SEGMENT_NAME',NULL,NULL,NULL,25,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,655);
INSERT INTO APP_COLUMN_NAME VALUES ('RF1 Info','RF1 Mileage','FA.RF1_MILEAGE',NULL,NULL,NULL,25,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,655);
INSERT INTO APP_COLUMN_NAME VALUES ('RF1 Info','On Reach Ind','FA.ON_REACH_IND',NULL,NULL,NULL,25,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,655);
INSERT INTO APP_COLUMN_NAME VALUES ('NRCS Watershed ID','NRCS Watershed ID','FA.NRCS_WATERSHED_ID',NULL,NULL,NULL,26,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Estuary Info','Primary Estuary','PRIMARY_ESTUARY',NULL,NULL,NULL,27,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,656);
INSERT INTO APP_COLUMN_NAME VALUES ('Estuary Info','Secondary Estuary','SECONDARY_ESTUARY',NULL,NULL,NULL,27,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,656);
INSERT INTO APP_COLUMN_NAME VALUES ('Estuary Info','Other Estuary Name','FA.OTHER_ESTUARY_NAME',NULL,NULL,NULL,27,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,656);
INSERT INTO APP_COLUMN_NAME VALUES ('Great Lake Name','Great Lake Name','FA.GREAT_LAKE_NAME',NULL,NULL,NULL,28,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Ocean Name','Ocean Name','FA.OCEAN_NAME',NULL,NULL,NULL,29,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Natv American Land Name','Natv American Land Name','FA.NATV_AMERICAN_LAND_NAME',NULL,NULL,NULL,30,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('FRS Key Identifier','FRS Key Identifier','FA.FRS_KEY_IDENTIFIER',NULL,NULL,NULL,31,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Description Text','Description Text','FA.DESCRIPTION_TEXT',NULL,NULL,NULL,31.5,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Document/Graphic Name ','Station Document/Graphic Name','FA.BLOB_TITLE',NULL,NULL,NULL,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO APP_COLUMN_NAME VALUES ('Station Document/Graphic URL ','Station Document/Graphic URL','FA.BLOB_ID',NULL,NULL,NULL,33,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);

COMMIT;

SPOOL OFF